<?php

namespace Plenty\Modules\Order\Models;

use Illuminate\Database\Eloquent\Model;

class OrderPosition extends Model 
{

    protected $table = 'plenty_order_position';
    public $timestamps = true;
    protected $fillable = array('orderId', 'typeId', 'referrer', 'variationId', 'variationQuantity', 'varitionName', 'attributeValues', 'characterValues', 'shippingProfil_xxx', 'warehouseId_xxxx', 'updatedAt', 'createdAt');
    protected $visible = array('orderId', 'typeId', 'referrer', 'variationId', 'variationQuantity', 'varitionName', 'attributeValues', 'characterValues', 'shippingProfil_xxx', 'warehouseId_xxxx', 'updatedAt', 'createdAt');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function positionType()
    {
        return $this->hasOne('OrderPositionType', 'id', 'typeId');
    }

    public function amount()
    {
        return $this->hasMany('OrderPositionAmount', 'orderId', 'id');
    }

    public function dateOptions()
    {
        return $this->hasMany('OrderPositionDateOption', 'orderPositionId', 'id');
    }

    public function childOrderPositionReference()
    {
        return $this->hasMany('OrderPositionReference', 'orderPositionId', 'id');
    }

    public function parentOrderPositionReference()
    {
        return $this->hasMany('OrderPositionReference', 'referenceOrderPosition', 'id');
    }

}